// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "degub.h"
#include "ini.h"
#include "common.h"
#include "version.h"
#include <crtdbg.h>
#include <new>
#include <dxerr9.h>

FILE *df=NULL;
Degub g_degub;
int g_con_total=0, g_con_num=0, g_arr_num=0;
int g_con_maximum=0, g_con_num_max=0, g_arr_num_max=0;
HWND g_hWnd = NULL;
int gMyLastError = 0;

//#define MY_DEGUB_NEW

#ifdef MY_DEGUB_NEW
DWORD g_new1=0, g_new2=0, g_del1=0, g_del2=0, g_new1s=0, g_new2s=0;

void* operator new(std::size_t _Count) {
	void *ptr = HeapAlloc(GetProcessHeap(), 0, _Count);
	if(!ptr) throw std::bad_alloc();
	g_new1++;
	g_new1s += _Count;
	return ptr;
}
void* operator new(std::size_t _Count, const std::nothrow_t&) throw() {
	void *ptr = HeapAlloc(GetProcessHeap(), 0, _Count);
	if(!ptr) {
		DEGUB("new allocation failed: %i bytes\n", _Count);
	}
	g_new2++;
	g_new2s += _Count;
	return ptr;
}
void operator delete(void* _Ptr) throw() {
	g_del1++;
	if(g_new1 == g_del1) {
		OutputDebugString("Del1 Zero\n");
	}// else
	//OutputDebugString("Del1 %i\n");
	GLE(HeapFree(GetProcessHeap(), 0, _Ptr));
}
void operator delete(void* _Ptr, const std::nothrow_t&) throw() {
	g_del2++;
	if(g_new2 == g_del2) {
		OutputDebugString("Del2 Zero\n");
	}
	GLE(HeapFree(GetProcessHeap(), 0, _Ptr));
}
#endif	//MY_DEGUB_NEW

/*int MyAllocHook(int allocType, void *userData, size_t size, int blockType,
long requestNumber, const unsigned char *filename, int lineNumber) {
userData;
filename;
lineNumber;

static int totblocks=0, maxsize=0, maxblocks=0;
static size_t totsize=0;

if(blockType == _CRT_BLOCK)
return(true);

DEGUB("Op: ");
switch(allocType) {
CASEDEGUB(_HOOK_ALLOC);
CASEDEGUB(_HOOK_REALLOC);
CASEDEGUB(_HOOK_FREE);
}
DEGUB("\tType: ");
switch(blockType) {
CASEDEGUB(_NORMAL_BLOCK);
CASEDEGUB(_CLIENT_BLOCK);
CASEDEGUB(_FREE_BLOCK);
CASEDEGUB(_IGNORE_BLOCK);
}
if(allocType == _HOOK_ALLOC) {
totblocks++;
totsize += size;
}
if(allocType == _HOOK_FREE) {
totblocks--;
}
DEGUB("\tSize: %i\tReq: %i\tTS: %i\tTB: %i\n", size, requestNumber,
totsize, totblocks);

return true;
}*/

CRITICAL_SECTION g_cs, cs_tomb;

Degub::Degub() {
	int tmpFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
	tmpFlag |= _CRTDBG_LEAK_CHECK_DF | //_CRTDBG_DELAY_FREE_MEM_DF |
		_CRTDBG_ALLOC_MEM_DF;
	_CrtSetDbgFlag(tmpFlag);

	//_CrtSetAllocHook(MyAllocHook);

	InitializeCriticalSection(&g_cs);
	InitializeCriticalSection(&cs_tomb);

	name = "degub.txt";
	remove("degub.old.txt");
	::rename(name.c_str(), "degub.old.txt");
	df = _fsopen(name.c_str(), "w", _SH_DENYWR);
}

std::string clearFileName(const char *name) {
	std::string nn;
	size_t i=0;
	while(name[i] != 0) {
		switch(name[i]) {
		case '<': case '>': case ':': case '\"': case '/': case '\\': case '|':
			break;
		default:
			nn += name[i];
		}
		i++;
	}
	return nn;
}
bool Degub::restart(const char *newname) {
	if(g::degub_on) {
		EnterCriticalSection(&g_cs);
		std::string nn = clearFileName(newname);
		DEGUB("Restarting %s to %s\n", name.c_str(), nn.c_str());
		if(nn != name) {
			fclose(df);
			if(name == "degub.txt") {
				remove(nn.c_str());  //DELETED!!
				if(::rename(name.c_str(), nn.c_str())) {
					FAIL(UE_GENERIC_ERROR);
				}
				df = _fsopen(nn.c_str(), "a", _SH_DENYWR);
			} else {
				df = _fsopen(nn.c_str(), "w", _SH_DENYWR);
			}
		}
		DEGUB("Restarted %s to %s\n", name.c_str(), nn.c_str());
		name = nn;
		LeaveCriticalSection(&g_cs);
	}
	return true;
}
bool Degub::rename(const char *newname) {
	if(g::degub_on) {
		EnterCriticalSection(&g_cs);
		std::string nn = clearFileName(newname);
		DEGUB("Renaming %s to %s\n", name.c_str(), nn.c_str());
		if(nn != name) {
			fclose(df);
			if(name != nn) {
				remove(nn.c_str());  //DELETED!!
			}
			if(::rename(name.c_str(), nn.c_str())) {
				FAIL(UE_GENERIC_ERROR);
			}
			df = _fsopen(nn.c_str(), "a", _SH_DENYWR);
		}
		DEGUB("Renamed %s to %s\n", name.c_str(), nn.c_str());
		name = nn;
		LeaveCriticalSection(&g_cs);
	}
	return true;
}
void Degub::turn_off() {
	EnterCriticalSection(&g_cs);
	fprintf(df, "Turning off %s\n", name.c_str());
	fclose(df);
	remove("degub.txt");	//DELETED!!
	name = "";
	LeaveCriticalSection(&g_cs);
}

void degub_degub(const char *format, ...) {
	/*const int SpinLimit = 4;
	int retries = 0;
	while(!TryEnterCriticalSection(&g_cs)) {
	if(retries++ < SpinLimit){
	Sleep(0);
	continue;
	}*/
	EnterCriticalSection(&g_cs);
	/*    break;
	}*/

	va_list ap;
	va_start(ap, format);
	vfprintf(df, format, ap);
	va_end(ap);

#ifdef _DEBUG
	_flushall();
#endif
	LeaveCriticalSection(&g_cs);
}

Degub::~Degub() {
#ifdef MY_DEGUB_NEW
	VDEGUB("new1: %i bytes in %i blocks, %i deleted\n", g_new1s, g_new1, g_del1);
	VDEGUB("new2: %i bytes in %i blocks, %i deleted\n", g_new2s, g_new2, g_del2);
#endif	//MY_DEGUB_NEW
	VDEGUB("Con Max: %i bytes in %i Containers and %i Arrays\n",
		g_con_maximum, g_con_num_max, g_arr_num_max);
	VDEGUB("Con Leak: %i bytes in %i Containers and %i Arrays\n",
		g_con_total, g_con_num, g_arr_num);
	if(g_con_total != 0 || g_con_num != 0 || g_arr_num != 0)
		THE_ONE_MESSAGE_BOX("Memory leak detected!");
	DEGUB("EOF\n");
	_flushall();
	//fclose(df);
	//DeleteCriticalSection(&s_cs);
}

string FormatError(const string& aType, DWORD aCode, const string& aTranslated)
{
	char *lpMsgBuf;
	int formatResult=0;

#define LOAD_DESC(ue, desc) case ue: lpMsgBuf = desc; break;
	if(IS_USER_ERROR(aCode)) {
		switch(aCode) {
			UE_ERROR_CODES(LOAD_DESC);
		default:
			lpMsgBuf = "Bad error code!!!";
		}
	} else {
		formatResult = FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
			FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, aCode,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&lpMsgBuf, 0, NULL);
		if(formatResult == 0) {
			lpMsgBuf = "FormatMessage Error";
		}
		if(formatResult != 0)
			lpMsgBuf[formatResult - 2] = 0;
	}

	string buffer = aTranslated + ": \"" + lpMsgBuf + "\"";
	DEGUB("%s reports %s\n", aType.c_str(), buffer.c_str());

	if(formatResult != 0)
		LocalFree(lpMsgBuf);

	return buffer;
}
string FormatGLE() {
	if(gMyLastError != 0)
		SetLastError(gMyLastError);
	DWORD gle = GetLastError();
	return FormatError("GetLastError", gle, TranslateGLE(gle));
}
void DoGLE() {
	string s = FormatGLE();
	gMyLastError = 0;
	THE_ONE_MESSAGE_BOX(s);
}
void DumpGLE() {
	if(gMyLastError == 0)
		gMyLastError = GetLastError();
	FormatGLE();
}
void ThrowGLE() {
	string s = FormatGLE();
	gMyLastError = 0;
	throw generic_fatal_exception(s);
}

void DoCDEE(DWORD cdee) {
	THE_ONE_MESSAGE_BOX(FormatError("CommDlgExtendedError", cdee,
		TranslateCDEE(cdee)));
}

void DoDXErr(HRESULT hr) {
	DEGUB("DirectX Error: %s\n", DXGetErrorString9(hr));
	_flushall();
	THE_ONE_MESSAGE_BOX(DXGetErrorString9(hr));
}

bool _TheOneMessageBox(const string& message) {
	static bool box_open = false;
	if(!box_open) {
		box_open = true;
		DEGUB("TheOneMessageBox says: %s\n", message.c_str());
		_flushall();
		if(!MessageBox(IsWindow(g_hWnd) ? g_hWnd : NULL, message.c_str(), APP_NAME,
			MB_ICONSTOP))
		{
			if(GetLastError() == ERROR_INVALID_WINDOW_HANDLE) {
				DEGUB("IsWindow seems to have been mistaken. Very weird. "
					"Probably a cascading failure.\n");
				GLE(MessageBox(NULL, message.c_str(), APP_NAME, MB_ICONSTOP));
				FORCED_CRASH;
			} else {
				DO_GLE;
			}
		}
		if(g::degub_msg) {
			DEGUB("TheOneMessageBox is closed\n");
		}
		_flushall();
		box_open = false;
	}
	return true;
}
